#include "CarData.h"
#include <stdint.h>

#if __cplusplus < 201103L
  #error Compiler configuration is not C++11 compliant.
#endif

// Implementation of the constructor

CarData::CarData(int VIN, EngineRunning_t EngineRunning, CrashDetected_t CrashDetected, LockState_t LockState, LockMode_t LockMode, uint16_t Velocity)
    : VIN(VIN), EngineRunning(EngineRunning), CrashDetected(CrashDetected), LockState(LockState), LockMode(LockMode), Velocity(Velocity) {
}

//Implemention of the copy constructor
CarData::CarData(const CarData& source)
    : CarData{ source.VIN } {
}

// Implementation of the destructor
CarData::~CarData() {
}

void CarData::checkAutoLock(void) {
    if ( this->Velocity >= 25)      /* Turn lock on at 25 kph */
    {
        this->LockState = LockState_t::LOCKED;
    }
    else
    {
        this->LockState = LockState_t::UNLOCKED;
    }
}

void CarData::process_velocity_message(int velocity) {
    this->Velocity = velocity;

    if (this->LockMode == LockMode_t::AUTO_LOCK)
    {
        this->checkAutoLock();
    }
}